@php
    $groupIcons = [
        'Meta' => 'sliders-h',
        'Home Page' => 'house',
        'Footer' => 'shoe-prints',
        'Store' => 'money-bill',
        'News' => 'bullhorn',
        'Forum' => 'comments',
        'Keys' => 'key',
        'Design' => 'palette',
    ];
@endphp

@extends('layouts.admin')


@section('title', 'Site Configurations')

@section('content')
<div class="dashboard-container">
    <div class="dashboard-header">
        <h1>Configuration Management</h1>
        <p>Manage and update system configurations by category</p>
    </div>

    <div class="settings-page">
        <div class="nav-tabs">
            @foreach($groups as $groupItem)
                @if($groupItem === 'Navigation') @continue @endif
                <div class="nav-item">
                    <a href="{{ route('admin.configurations.index', ['group' => $groupItem]) }}" 
                       class="nav-link {{ $group == $groupItem ? 'active' : '' }}">
                        <i class="fas fa-{{ $groupIcons[$groupItem] ?? 'cog' }}"></i>
                        {{ ucfirst($groupItem) }}
                    </a>
                </div>
            @endforeach
        </div>

        <div class="dashboard-card dashboard-card-full">
            <div class="dashboard-card-header">
                <h3>{{ ucfirst($group) }} Settings</h3>
            </div>
            <div class="dashboard-card-body">

                <form action="{{ route('admin.configurations.batch-update') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <input type="hidden" name="group" value="{{ $group }}">
                    
                    <div class="config-grid">
                        @forelse($configurations as $config)
                            <div class="config-item">
                                <div class="config-label">
                                    <label for="config-{{ $config->id }}">{{ $config->description }}</label>
                                    <span class="config-key">{{ $config->key }}</span>
                                </div>
                                <div class="config-input">
                                    @if($config->type == 'boolean')
                                    <div class="toggle-switch">
                                        <input type="checkbox" name="configs[{{ $config->id }}]" 
                                               id="config-{{ $config->id }}" 
                                               value="1" {{ $config->value == '1' ? 'checked' : '' }}
                                               class="toggle-switch-checkbox">
                                        <label for="config-{{ $config->id }}" class="toggle-switch-label">
                                            <span class="toggle-switch-switch"></span>
                                        </label>
                                    </div>
                                    @elseif($config->type == 'json')
                                        <div class="json-editor">
                                            <textarea name="configs[{{ $config->id }}]" id="config-{{ $config->id }}"
                                                class="form-control json-textarea" rows="5">{{ $config->value }}</textarea>
                                            <div class="format-json-btn" data-target="config-{{ $config->id }}">
                                                <i class="fas fa-code"></i> Format JSON
                                            </div>
                                        </div>
                                    @elseif($config->type == 'color')
                                        <div class="color-picker-wrapper">
                                            <input type="color" name="configs[{{ $config->id }}]" id="config-{{ $config->id }}"
                                                class="color-picker-input" value="{{ $config->value ?? '#000000' }}">
                                            <input type="text" name="color_text_{{ $config->id }}" id="color-text-{{ $config->id }}"
                                                class="color-text-input form-control" value="{{ $config->value ?? '#000000' }}">
                                        </div>
                                    @elseif($config->type == 'icon')
                                        <div class="icon-picker-wrapper">
                                            <div class="icon-picker-preview">
                                                <i class="fas fa-{{ $config->value ?? 'question' }}" id="icon-preview-{{ $config->id }}"></i>
                                            </div>
                                            <input type="text" name="configs[{{ $config->id }}]" id="config-{{ $config->id }}"
                                                class="icon-picker-input form-control" value="{{ $config->value ?? '' }}" 
                                                placeholder="Search for an icon..." autocomplete="off">
                                            <div class="icon-picker-dropdown" id="icon-dropdown-{{ $config->id }}">
                                                <div class="icon-picker-search">
                                                    <input type="text" id="icon-search-{{ $config->id }}" 
                                                        class="icon-search-input form-control" placeholder="Search icons...">
                                                </div>
                                                <div class="icon-picker-list" id="icon-list-{{ $config->id }}">
                                                    {{-- Icons will be loaded here via JavaScript --}}
                                                </div>
                                            </div>
                                        </div>
                                    @elseif($config->type == 'select')
                                        <select name="configs[{{ $config->id }}]" id="config-{{ $config->id }}" class="form-control">
                                        @php
                                            $optionsString = $config->options ?? '';
                                            $options = !empty($optionsString) ? explode(',', $optionsString) : [];
                                            $currentValue = $config->value ?? '';
                                        @endphp
                                        
                                        @foreach($options as $option)
                                            @php
                                                $option = trim($option);
                                            @endphp
                                            <option value="{{ $option }}" {{ $currentValue == $option ? 'selected' : '' }}>
                                                {{ $option }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @elseif($config->type == 'file' || $config->type == 'image')
                                        <div class="file-upload-wrapper">
                                            <input type="file" name="file_configs[{{ $config->id }}]" id="config-{{ $config->id }}" 
                                                class="file-upload-input" data-max-size="2048">
                                            <label for="config-{{ $config->id }}" class="file-upload-label">
                                                <span class="file-upload-icon"><i class="fas fa-upload"></i></span>
                                                <span class="file-upload-text">Choose file</span>
                                            </label>
                                            <div class="file-upload-preview">
                                                @if($config->value)
                                                    <div class="current-file">
                                                        <span class="file-name">Current file</span>
                                                        @if(in_array(pathinfo($config->value, PATHINFO_EXTENSION), ['jpg', 'jpeg', 'png', 'gif', 'svg', 'ico']))
                                                            <img src="{{ asset($config->value) }}" alt="Current file" class="file-preview">
                                                        @else
                                                            <i class="fas fa-file"></i>
                                                        @endif
                                                        <input type="hidden" name="existing_files[{{ $config->id }}]" value="{{ $config->value }}">
                                                    </div>
                                                @endif
                                            </div>
                                        </div>
                                    @elseif($config->type == 'text' && strlen($config->value) > 100)
                                        <textarea name="configs[{{ $config->id }}]" id="config-{{ $config->id }}"
                                            class="form-control" rows="3">{{ $config->value }}</textarea>
                                    @else
                                        <input type="text" name="configs[{{ $config->id }}]" id="config-{{ $config->id }}"
                                            class="form-control" value="{{ $config->value }}">
                                    @endif
                                    
                                    @if($config->type != 'checkbox')
                                        <div class="config-type">{{ ucfirst($config->type) }}</div>
                                    @endif
                                </div>
                            </div>
                        @empty
                            <div class="no-configs">
                                <i class="fas fa-exclamation-circle"></i>
                                <p>No configurations found for this category.</p>
                            </div>
                        @endforelse
                    </div>

                    @if(count($configurations) > 0)
                        <div class="form-actions">
                            <button type="submit" class="btn btn-primary">
                                <i class="fas fa-save"></i> Save Changes
                            </button>
                        </div>
                    @endif
                </form>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Format JSON function
        document.querySelectorAll('.format-json-btn').forEach(btn => {
            btn.addEventListener('click', function() {
                const targetId = this.getAttribute('data-target');
                const textarea = document.getElementById(targetId);
                
                try {
                    const formatted = JSON.stringify(JSON.parse(textarea.value), null, 2);
                    textarea.value = formatted;
                } catch (e) {
                    alert('Invalid JSON format');
                }
            });
        });

        // File upload preview
        document.querySelectorAll('.file-upload-input').forEach(input => {
            input.addEventListener('change', function() {
                const fileName = this.files[0]?.name || '';
                const label = this.nextElementSibling.querySelector('.file-upload-text');
                const preview = this.parentElement.querySelector('.file-upload-preview');
                
                if (fileName) {
                    label.textContent = fileName;
                    
                    if (this.files[0] && this.files[0].type.startsWith('image/')) {
                        const reader = new FileReader();
                        reader.onload = function(e) {
                            preview.innerHTML = `
                                <div class="new-file">
                                    <span class="file-name">New file:</span>
                                    <img src="${e.target.result}" alt="File preview" class="file-preview">
                                </div>
                                ${preview.innerHTML}
                            `;
                        }
                        reader.readAsDataURL(this.files[0]);
                    }
                } else {
                    label.textContent = 'Choose file';
                }
            });
        });
    });
</script>
@endpush
@endsection